clc
clear
close all

% INPUT DATA

name = {'elev', 'srad', 'tavg', 'tmax', 'tmin', 'vapr', 'wind'}; % print the name of the folder
folder = cellfun(@(p) addpath(strrep("wc2.1_30s_%PARAM%", "%PARAM%", p)), name, 'UniformOutput', false);

months = sprintfc('%02d', 01); % print the # of the month 01 - 12

%% LOAD RASTER: 

disp("Loading raster...");

% average temperature
[Tavg, ref] = readgeoraster(strrep("wc2.1_30s_tavg\wc2.1_30s_tavg_%m%.tif", "%m%", months));
Tavg(Tavg == (min(Tavg, [], "all"))) = NaN;
Tavg = Tavg + 273.15; % from °C to K degrees

disp("Average temperature")

% wind velocity
wind = readgeoraster(strrep("wc2.1_30s_wind\wc2.1_30s_wind_%m%.tif", "%m%", months));
wind(wind == (min(wind, [], "all"))) = NaN;

disp("Wind elevation")

disp("COMPLETE.")

%% CALCULATION of the PARAMETERS for the Penman-Monteith Equation:

disp("Calculation of the parameters...")

gamma = load(strrep("gamma_%m%.mat", "%m%", months)); % in kPa/°C
gamma = gamma.gamma_tog;

disp("gamma")

delta = load(strrep("delta_%m%.mat", "%m%", months)); % in kPa/°C
delta = delta.delta_tog;

disp("delta")

VPD = load(strrep("VPD_%m%.mat", "%m%", months)); % in kPa
VPD = VPD.VPD_tog;
VPD(VPD<0) = 0;

disp("VPD")

Rn = load(strrep("Rn_%m%.mat", "%m%", months)); % in MJ/m^2d
Rn = Rn.Rn_tog;

disp("Rn")

disp("COMPLETE.")

%% PENMAN-MONTEITH EQUATION, according to the FAO method

disp("Calculation of Potential Evapotranspiration...")

PET = (0.408 .* delta .* Rn + (900./Tavg) .* gamma .* wind .* VPD) ./ ...
                    (delta + gamma.*(1+0.34.*wind));

PET = PET .* 30; % mm/mo


%%
disp("Saving PET...")

save(strrep("PET_%m%.mat", "%m%", months), "PET", "-v7.3");

geotiffwrite(strrep("PET_%m%.tif", "%m%", months), PET, ref, ...
             'TiffTags', struct('Compression', Tiff.Compression.None));


disp("COMPLETE.")
